@extends('layouts.master')
@section('title',__('Addon Manager'))
@section('breadcum')
	<div class="breadcrumbbar">
        <h4 class="page-title">{{ __('Addon Manager') }}</h4>
        <div class="breadcrumb-list">
            <ol class="breadcrumb">
              <li class="breadcrumb-item"><a href="{{url('/admin')}}" title="{{ __('Dashboard') }}">{{ __('Dashboard') }}</a></li>
              <li class="breadcrumb-item active" aria-current="page">{{ __('Addon Manager') }}</li>
            </ol>
        </div>                    
    </div>
    
@endsection
@section('maincontent')
<div class="contentbar"> 
    <div class="row">
        <div class="col-md-12">

            <div class="card">
                <div class="card-header">
                    <button type="button" class="float-right btn btn-primary-rgba mr-2 " data-toggle="modal"
                    data-target=".bd-example-modal-lg" title="{{ __('Install New Addon') }}"><i class="feather icon-plus mr-2"></i> {{ __('Install New Addon') }} </button>
            
            {{-- Install new Addon Model Start --}}
                <div class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true">
                    <div class="modal-dialog modal-md">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleLargeModalLabel">{{__("Install New Addon")}}</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close" title="{{ __('Close') }}">
                                <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                                
                            <div class="modal-body">
                                <form action="{{ route('addon.install') }}" method="POST" enctype="multipart/form-data">
                                    @csrf
                                    <div class="form-group">
                                        <label>{{__('Enter Purchase Code')}}: <span class="text-danger">*</span></label>
                                        <input type="text" placeholder="{{__('Enter Purchase Code of Your Addon')}}" class="form-control" name="purchase_code">
                                    </div>
            
                                    <div class="form-group">
                                        <label>{{__('Choose Addon Zip File')}}: <span class="text-danger">*</span></label>
                                        <input type="file" class="form-control" name="addon_file">
                                    </div>
                                    
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="customCheck1" name="eula"/>
                                        <label class="custom-control-label" for="customCheck1"><b>I agree <a href="" title="">Privacy Policy.</a></b></label>
                                    </div>                                    
                                    
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-primary" title="{{__('Install')}}"><i class="feather icon-plus"></i> {{__('Install')}}</button>
                                     
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            {{-- Install new Addon Model End --}}
                    <h5 class="card-title">{{ __('Addon Manager') }}</h5>                    
                </div> 

                <div class="card-body">
                    <div class="table-responsive">
                        <table id="modules" class="table table-bordered">
                            <thead>
                                <th>#</th>
                                <th>{{__('Logo')}}</th>
                                <th>{{__('Addon Name')}}</th>
                                <th>{{__('Status')}}</th>
                                <th>{{__('Version')}}</th>
                                <th>{{__('Actions')}}</th>
                            </thead>                    
                            <tbody>
                                @php $i = 1; @endphp
                                @foreach($modules as $module)
                                <tr>
                                    <td>{{ $i++ }}</td>
                                    <td>
                                        @if(isset($module['alias']))
                                            <img class="pull-left" src="{{ Module::asset($module['alias'] . ':logo/' . $module['alias'] . '.png') }}" alt="NEXTHOUR"/>
                                        @else
                                            <img class="pull-left" src="#" alt="NEXTHOUR"/>
                                        @endif
                                    </td>
                                    <td>
                                        <b>{{ $module['name'] ?? 'Unknown Module' }}</b>
                                        <p>{{ $module['description'] ?? '' }}</p>
                                    </td>
                                    <td>
                                        <div class="custom-switch">
                                            <input type="checkbox" class="custom-switch-input toggle-module" id="customSwitch_{{ $i }}" data-name="{{ $module['name'] ?? '' }}" {{ isset($module['status']) && $module['status'] == 1 ? 'checked' : '' }}>
                                            <label class="custom-switch-label" for="customSwitch_{{ $i }}"></label>
                                        </div>
                                    </td>
                                    <td>{{ $module['version'] ?? 'N/A' }}</td>
                                    <td>
                                        @if(isset($module['manage_settings_url']) && $module['manage_settings_url'])
                                            <a href="{{ $module['manage_settings_url'] }}" class="btn btn-info-rgba btn-sm" title="{{ __('Settings') }}">
                                                <i class="feather icon-settings"></i>
                                            </a>
                                        @endif
                                        <button class="btn btn-danger-rgba btn-sm delete-addon" data-name="{{ $module['name'] ?? '' }}" title="{{ __('Delete') }}">
                                            <i class="feather icon-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                @endforeach                   
                            </tbody>
                        </table>           
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 
@section('script')
<script>
$(document).ready(function() {
  // Handle toggle switches for enabling/disabling modules
  $('.toggle-module').on('change', function() {
    var status = $(this).prop('checked') ? 1 : 0;
    var moduleName = $(this).data('name');
    
    $.ajax({
      type: 'POST',
      url: "{{ url('/admin/toggle/module') }}",
      data: {
        status: status,
        modulename: moduleName,
        _token: "{{ csrf_token() }}"
      },
      dataType: 'json',
      success: function(data) {
        if(data.status === 'success') {
          toastr.success(data.msg);
        } else {
          toastr.error(data.msg);
          // Revert toggle if failed
          $('.toggle-module[data-name="' + moduleName + '"]').prop('checked', !status);
        }
      },
      error: function(xhr) {
        console.error(xhr.responseText);
        toastr.error('An error occurred while processing your request.');
        // Revert toggle if error
        $('.toggle-module[data-name="' + moduleName + '"]').prop('checked', !status);
      }
    });
  });

  // Handle module deletion
  $('.delete-addon').on('click', function() {
    var moduleName = $(this).data('name');
    
    if (confirm('Are you sure you want to delete this addon? This action cannot be undone.')) {
      $.ajax({
        type: 'POST',
        url: "{{ url('/admin/addon/delete') }}",
        data: {
          modulename: moduleName,
          _token: "{{ csrf_token() }}"
        },
        success: function(response) {
          if (response.success) {
            toastr.success(response.success);
            // Reload the page after successful deletion
            window.location.reload();
          } else if (response.deleted) {
            toastr.error(response.deleted);
          }
        },
        error: function(xhr) {
          console.error(xhr.responseText);
          toastr.error('An error occurred while deleting the addon.');
        }
      });
    }
  });

  // Form validation for addon installation
  $('form').on('submit', function(e) {
    var purchaseCode = $('input[name="purchase_code"]').val();
    var addonFile = $('input[name="addon_file"]').val();
    var eula = $('input[name="eula"]').is(':checked');
    
    if (!purchaseCode) {
      e.preventDefault();
      toastr.error('Please enter purchase code');
      return false;
    }
    
    if (!addonFile) {
      e.preventDefault();
      toastr.error('Please select an addon file');
      return false;
    }
    
    if (!eula) {
      e.preventDefault();
      toastr.error('Please agree to the Privacy Policy');
      return false;
    }
    
    return true;
  });
});
</script>
@endsection